#version 330
#extension GL_EXT_gpu_shader4 : enable
//  Glass bubble lamp forkMod01.fsh  by   jolle

//https://www.shadertoy.com/view/WtdBDM
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Based on Glass bubble lamp by jarble https://www.shadertoy.com/view/ttcfD7

// Tries to focus on the most interesting part,
// and overlaps two fractals so it has less empty space

const float pi = 3.14159265359;
const float t = 9.0;

vec4 fractal(vec2 v, float ph1, float ph2)
{
    vec2 u = v * dot(v, v);
    vec4 sum = vec4(0.);
    for (float i = 0.; i < t; ++i)
    {
        u = cos(u.y-vec2(.0,.5*pi))*exp(sin(u.x+ph1)+cos(u.y+ph2));
        u+= v;
        sum += (.5+.5*cos(i*4.+vec4(0,1,2,0)))/length(u);
    }
    return sum;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 u = 1.25*(2.*gl_FragCoord.xy-iResolution.xy)/iResolution.y * vec2(-1.0, 1.0);
    float ph1 = iTime * 0.6;
    float ph2 = sin(iTime * 0.31) * 0.3;
    gl_FragColor = sqrt(fractal(u, ph1, ph2) + fractal(u, ph1 + pi, ph2)) * 0.25 - 0.25;
}